global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob2_2Prop")
local handlestate

handlestate = 0

-- space/time throttle

global function AnimDone()
	local anim 
	local ce5 = FindNodeByName("ce5")
	
	ce5:Trigger()
		
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever_down")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever_up")
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()	
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever_raising")

	handlestate = 1

	FindNodeByName("ob_2_2_timespace_forwards"):Trigger()

	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever")

	handlestate = 0

	FindNodeByName("ob_2_2_timespace_backwards"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end
	
	FindNodeByName("Console2InteractableScript").script.Object2State = handlestate
	
	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2251:Time and Space Forward/Back Control: Forwards or backwards, pretty self explanatory really. I think that's what it's for, anyway.
		else
			--VO Console Control Text
			amy::SID_2252:Only moves forwards or backwards. That must be all it does. Doesn't this thing have gears?
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim
	
	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever_down")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_group67_Anim_Time_Space_lever_up")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end

